"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mesaRedondaConfirmPresenca = exports.getMesaRedonda = exports.getMesaRedondas = exports.register = void 0;
const counter_1 = __importDefault(require("../models/counter"));
const express_validator_1 = require("express-validator");
const membro_1 = __importDefault(require("../models/membro"));
const pagination_1 = require("../util/pagination");
const mesa_redonda_1 = __importDefault(require("../models/mesa-redonda"));
const main_1 = require("../util/main");
const evento_1 = __importDefault(require("../models/evento"));
const emailer_1 = __importDefault(require("../util/emailer"));
const register = async (req, res, next) => {
    try {
        const { eventoId, numeroCarteira, nome, dataNascimento, genero, profissao, localTrabalho, email, tel, } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const verifyEmail = await mesa_redonda_1.default.findOne({ email });
        if (verifyEmail) {
            const error = new Error(`Já tens um registo para este Evento!`);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findOne({ numeroCarteira });
        //   const emolumento = await Emolumento.findById(emolumentoId);
        //   if (!emolumento) {
        //     const error: IError = new Error(`Emolumento não encontrado!`);
        //     error.statusCode = 422;
        //     throw error;
        //   }
        // Payment
        //   const pagamento = await generateReference(emolumento, 'mesaRedonda', membro.dadosPessoais, {
        //     membro: { nome: membro.nome, _id: membro._id },
        //   });
        const evento = await evento_1.default.findById(eventoId);
        if (!evento) {
            const error = new Error(`Evento não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        if (evento.inscricoes >= 300) {
            const error = new Error(`O número de inscrições para este evento está esgotado!`);
            error.statusCode = 422;
            throw error;
        }
        // Counter para gerar o numero de sequencia
        const counter = await counter_1.default.findOneAndUpdate({ id: 'mesaRedonda' }, { $inc: { seq: 1 } }, { new: true, upsert: true });
        const mesaRedonda = new mesa_redonda_1.default({
            evento: eventoId,
            numeroCarteira,
            nome,
            dataNascimento,
            genero,
            profissao,
            localTrabalho,
            email,
            tel,
            numero: counter.seq,
        });
        if (Boolean(membro)) {
            mesaRedonda.membro = membro === null || membro === void 0 ? void 0 : membro._id;
        }
        await mesaRedonda.save();
        evento.inscricoes = evento.inscricoes + 1;
        await evento.save();
        if (Boolean(email)) {
            const msg = {
                to: email,
                from: process.env.SENDER_EMAIL,
                subject: `Inscrição nº ${evento.inscricoes}`,
                html: `<h1>Inscrição Realizada com sucesso</h1>
              <p>
                 Parabéns as sua inscrição para participar da Mesa Redonda foi realizada com sucesso.
              </p>

              <p>
                Inscrição nº ${evento.inscricoes}
              </p>
              
              <p><b>Nota:</b> Este e-mail foi gerado automaticamente pela plataforma <b>OFA - CRL</b></p>
            `,
            };
            await emailer_1.default.send(msg);
        }
        res.status(201).json({
            msg: 'Sucesso',
            mesaRedonda,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.register = register;
const getMesaRedondas = async (req, res, next) => {
    try {
        const { status, count } = req.query;
        let mesaRedondas, total;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(status)) {
            filterObj.status = status;
        }
        if (Boolean(count) && JSON.parse(count)) {
            total = await mesa_redonda_1.default.find(filterObj).count();
        }
        else {
            total = await mesa_redonda_1.default.find(filterObj).count();
            mesaRedondas = await mesa_redonda_1.default.find(filterObj)
                .skip((0, pagination_1.skip)(page, perPage))
                .limit(perPage)
                .sort((0, main_1.sortBy)(req.query.sortBy || 'createdAt:ASC'));
        }
        res.status(200).json({
            msg: 'Sucesso',
            mesaRedondas,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getMesaRedondas = getMesaRedondas;
const getMesaRedonda = async (req, res, next) => {
    try {
        const { id } = req.params;
        const mesaRedonda = await mesa_redonda_1.default.findById(id);
        res.status(200).json({ msg: 'Sucesso', mesaRedonda });
    }
    catch (err) {
        next(err);
    }
};
exports.getMesaRedonda = getMesaRedonda;
const mesaRedondaConfirmPresenca = async (req, res, next) => {
    try {
        const { id } = req.params;
        const mesaRedonda = await mesa_redonda_1.default.findById(id);
        if (!mesaRedonda) {
            const error = new Error(`Participante não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        mesaRedonda.presenca = !mesaRedonda.presenca;
        await mesaRedonda.save();
        res.status(200).json({ msg: 'Sucesso', mesaRedonda });
    }
    catch (err) {
        next(err);
    }
};
exports.mesaRedondaConfirmPresenca = mesaRedondaConfirmPresenca;
