"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPagamentoByRef = exports.getPagamento = exports.getByDadosPessoaisId = exports.getTaxas = exports.getPagamentosAll = exports.getPagamentos = exports.payTaxaByReference = exports.payQuotaByReference = exports.payByReference = exports.postPaymentProxyPay = void 0;
const pagamento_1 = __importDefault(require("../models/pagamento"));
const express_validator_1 = require("express-validator");
const emolumento_1 = __importDefault(require("../models/emolumento"));
const membro_1 = __importDefault(require("../models/membro"));
const aws_1 = require("../util/aws");
const situacao_financeira_1 = __importDefault(require("../models/situacao-financeira"));
const user_1 = __importDefault(require("../models/user"));
const financa_1 = require("../util/financa");
const main_1 = require("../util/main");
const pagination_1 = require("../util/pagination");
const referencia_1 = __importDefault(require("../models/referencia"));
const pagamento_referencia_1 = __importDefault(require("../models/pagamento-referencia"));
const date_fns_1 = require("date-fns");
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const proxypay_1 = __importStar(require("../services/proxypay"));
const validate_url_1 = __importDefault(require("../util/validate-url"));
const postmark_1 = __importDefault(require("../services/postmark"));
/*
  Controller para receber pagamento
  da ProxyPay via Webhook
  Criar Validation Schema
*/
const postPaymentProxyPay = async (req, res, next) => {
    var _a;
    try {
        let { transaction_id, terminal_type, terminal_transaction_id, terminal_location, terminal_id, reference_id, product_id, period_start_datetime, period_id, period_end_datetime, parameter_id, id, fee, entity_id, datetime, custom_fields, amount, } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const signature = req.get('X-Signature');
        if (!signature) {
            const error = new Error('Não autorizado!');
            error.statusCode = 401;
            throw error;
        }
        if (!(0, main_1.validateSignature)(process.env.PROXYPAY_TOKEN, req.body, signature)) {
            const error = new Error('Não autorizado!');
            error.statusCode = 401;
            throw error;
        }
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        /*
          Metodo o executa o pagamento proxyPay
          retorna o pagamento
        */
        const pagamento = await (0, financa_1.postProxyPay)(transaction_id, terminal_type, terminal_transaction_id, terminal_location, terminal_id, reference_id, product_id, period_start_datetime, period_id, period_end_datetime, parameter_id, id, fee, entity_id, datetime, custom_fields, amount);
        if (pagamento) {
            if (pagamento.emolumento) {
                if ((_a = pagamento === null || pagamento === void 0 ? void 0 : pagamento.emolumento) === null || _a === void 0 ? void 0 : _a.designacao.includes('Quota')) {
                    // Verifica se o pagamento é Quota
                    // Pega o membro
                    const membro = await membro_1.default.findOne({
                        dadosPessoais: pagamento.dadosPessoais,
                    });
                    /*
                  Buscas as as sistuacao financeira do membro
                  referente ao mes e ano altera pra 'Pago'
                */
                    if (membro) {
                        let situacaoFinanceira = await situacao_financeira_1.default.findOne({
                            membro: membro.id,
                            ano: pagamento.ano,
                            mes: pagamento.mes,
                        });
                        if (!situacaoFinanceira) {
                            situacaoFinanceira = await situacao_financeira_1.default.create({
                                membro: membro.id,
                                ano: pagamento.ano,
                                mes: pagamento.mes,
                                status: 'Pago',
                            });
                        }
                        else {
                            situacaoFinanceira.status = 'Pago';
                            await situacaoFinanceira.save();
                        }
                        // Verifica a situacao finaceira do membro para alterar o seu estado
                        if (membro && pagamento.mes && pagamento.ano) {
                            const data = new Date((0, main_1.getAngolaTime)());
                            const anoActual = data.getFullYear();
                            const mesActual = data.getMonth() + 1;
                            await (0, financa_1.checkMembroSF)(membro.id, mesActual, anoActual);
                        }
                    }
                }
            }
            await (0, financa_1.addFecho)(pagamento);
        }
        res.status(201).json({
            msg: 'Sucesso',
        });
    }
    catch (err) {
        next(err);
    }
};
exports.postPaymentProxyPay = postPaymentProxyPay;
// Controller pagamento por reference - Por enquanto para test
const payByReference = async (req, res, next) => {
    try {
        let { emolumentoId, membroId, userId } = req.body;
        let admin;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrado!');
                error.statusCode = 422;
                throw error;
            }
        }
        const membro = await membro_1.default.findById(membroId).populate('dadosPessoais');
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const emolumento = await emolumento_1.default.findById(emolumentoId);
        if (!emolumento) {
            const error = new Error('Emolumento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        // Payment
        const dataExpiracao = (0, date_fns_1.addDays)(new Date((0, main_1.getAngolaTime)()), 3);
        const pagamento = await (0, financa_1.generateReference)(emolumento, membro.dadosPessoais, dataExpiracao, 
        // campo costomizavel
        {
            membroId: membro.id,
            emolumentoId: emolumento.id,
        });
        if (admin) {
            await (0, main_1.createHistoricoActividade)(`Gerou referência de ${pagamento.emolumento.designacao}`, 'Pagamento', pagamento.id, admin);
        }
        res.status(201).json({ msg: 'Pagamento', pagamento });
    }
    catch (err) {
        next(err);
    }
};
exports.payByReference = payByReference;
// Controller para pagamento de cota por referencia
const payQuotaByReference = async (req, res, next) => {
    var _a;
    try {
        let { montante, membroId, emolumentoId, userId, mes, ano } = req.body;
        const currentDate = (0, main_1.formatDate)(new Date((0, main_1.getAngolaTime)()));
        const dataExpiracao = (0, date_fns_1.addDays)(currentDate, 3);
        let admin;
        let ref;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrado!');
                error.statusCode = 422;
                throw error;
            }
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const emolumento = await emolumento_1.default.findById(emolumentoId);
        if (!emolumento) {
            const error = new Error('Emolumento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (!emolumento.designacao.includes('Quota')) {
            const error = new Error('Emolumento inválido!');
            error.statusCode = 422;
            throw error;
        }
        const foundPagamento = await pagamento_1.default.findOne({
            emolumento: emolumentoId,
            mes: mes,
            ano: ano,
            dadosPessoais: membro.dadosPessoais,
        });
        if (foundPagamento) {
            const error = new Error(`Referência de ${(0, main_1.getMes)(mes)} de ${ano} já criada: ${(_a = foundPagamento.referencia) === null || _a === void 0 ? void 0 : _a.status}`);
            error.statusCode = 422;
            throw error;
        }
        // ProxyPay Gera Referencia
        let reference = await proxypay_1.default.post(`reference_ids`, {});
        ref = reference.data;
        const foundReferencia = await referencia_1.default.findOne({
            ref: ref,
            status: { $ne: 'Expirada' },
        });
        const pagamentoReferencia = await pagamento_referencia_1.default.findOne({
            reference_id: ref,
        });
        if (foundReferencia || pagamentoReferencia) {
            const error = new Error(`Referência '${ref}' já existe, por favor gera novamente!`);
            error.statusCode = 422;
            throw error;
        }
        // Requisição ao ProxyPay
        await proxypay_1.default.put(`references/${ref}`, {
            amount: montante,
            end_datetime: dataExpiracao,
            custom_fields: {
                emolumento: emolumento.designacao,
                callback_url: 'https://ofa-production-server.vamsolucoes.com/api/v2/payments/proxypay/post',
            },
        });
        const referencia = new referencia_1.default({
            entidade: 10160,
            montante: montante,
            ref: ref,
            dadosPessoais: membro.dadosPessoais,
            emolumento: emolumentoId,
            dataExpiracao: dataExpiracao,
        });
        const pagamento = new pagamento_1.default({
            entidade: 10160,
            valorPagar: emolumento.valor,
            ref: ref,
            referencia: referencia.id,
            mes,
            ano,
            emolumento: emolumentoId,
            dadosPessoais: membro.dadosPessoais,
            tipo: 'Entrada',
        });
        if (admin) {
            referencia.admin = userId;
            pagamento.admin = userId;
            await (0, main_1.createHistoricoActividade)('Gerou referência quota', 'Pagamento', pagamento.id, admin);
        }
        await referencia.save();
        await pagamento.save();
        const situacaoFinanceira = await situacao_financeira_1.default.findOne({
            mes: pagamento.mes,
            ano: pagamento.ano,
            membro: membroId,
        });
        let newSF;
        if (!situacaoFinanceira) {
            newSF = await situacao_financeira_1.default.create({
                mes: pagamento.mes,
                ano: pagamento.ano,
                membro: membroId,
                status: 'Pendente',
            });
        }
        else {
            situacaoFinanceira.status = 'Pendente';
            await situacaoFinanceira.save();
        }
        res.status(201).json({
            msg: 'Successo',
            referencia,
            pagamento,
            situacaoFinanceira: newSF || situacaoFinanceira,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.payQuotaByReference = payQuotaByReference;
// Controller para registar pagamento de taxa por reference
const payTaxaByReference = async (req, res, next) => {
    var _a, _b;
    try {
        let { emolumentoId, membroId, userId } = req.body;
        const currentDate = (0, main_1.formatDate)(new Date((0, main_1.getAngolaTime)()));
        const dataExpiracao = (0, date_fns_1.addDays)(currentDate, 3);
        let admin, ref;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrado!');
                error.statusCode = 422;
                throw error;
            }
        }
        const membro = await membro_1.default.findById(membroId).populate('dadosPessoais');
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const emolumento = await emolumento_1.default.findById(emolumentoId);
        if (!emolumento) {
            const error = new Error('Emolumento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (!emolumento.designacao.includes('Taxa')) {
            const error = new Error('Emolumento inválido!');
            error.statusCode = 422;
            throw error;
        }
        const foundPagamento = await pagamento_1.default.findOne({
            emolumento: emolumentoId,
            dadosPessoais: membro.dadosPessoais.id,
        }).populate('referencia');
        if (foundPagamento) {
            const error = new Error(`Referência para ${(_a = emolumento === null || emolumento === void 0 ? void 0 : emolumento.designacao) === null || _a === void 0 ? void 0 : _a.toLowerCase()} já criada: ${(_b = foundPagamento.referencia) === null || _b === void 0 ? void 0 : _b.status}!`);
            error.statusCode = 422;
            throw error;
        }
        // ProxyPay Gera Referencia
        let reference = await proxypay_1.default.post('reference_ids', {});
        ref = reference.data;
        const foundReferencia = await referencia_1.default.findOne({
            ref: ref,
            status: { $ne: 'Expirada' },
        });
        const pagamentoReferencia = await pagamento_referencia_1.default.findOne({
            reference_id: ref,
        });
        if (foundReferencia || pagamentoReferencia) {
            const error = new Error(`Referência '${ref}' já existe, por favor gera novamente!`);
            error.statusCode = 422;
            throw error;
        }
        // Requisição ao ProxyPay
        await proxypay_1.default.put(`references/${ref}`, {
            amount: emolumento.valor,
            end_datetime: dataExpiracao,
            custom_fields: {
                emolumento: emolumento.designacao,
                callback_url: 'https://ofa-production-server.cnp.ao/api/v2/payments/proxypay/post',
            },
        });
        const referencia = new referencia_1.default({
            montante: emolumento.valor,
            ref: ref,
            dadosPessoais: membro.dadosPessoais.id,
            emolumento: emolumentoId,
            dataExpiracao: dataExpiracao,
        });
        const pagamento = new pagamento_1.default({
            valorPagar: emolumento.valor,
            ref: ref,
            referencia: referencia.id,
            emolumento: emolumentoId,
            dadosPessoais: membro.dadosPessoais.id,
            tipo: 'Entrada',
        });
        if (admin) {
            referencia.admin = userId;
            pagamento.admin = userId;
            await (0, main_1.createHistoricoActividade)('Gerou referência taxa inscrição', 'Pagamento', pagamento.id, admin);
        }
        await referencia.save();
        await pagamento.save();
        await postmark_1.default.sendEmail({
            To: membro.dadosPessoais.email,
            From: process.env.SENDER_EMAIL,
            Subject: 'Inscrição na Ordem dos Farmacêticos de Angola (OFA)',
            HtmlBody: `<h1>Estado da Inscrição na OFA</h1>
        <p>
          A sua inscrição foi realizada com sucesso seu número 
          de inscrição é: <b>${membro.numeroInscricao}</b> e seu processo 
          está <b>${membro.numeroInscricao}</b>.
        </p>

        <p>
          Deverá efetuar o pagamento da taxa de Inscrição, atraves 
          do ATM ou Multicaixa Express, segue  a baixo os dados de pagamento:
        </p>

        <p><b>Referência:</b> ${pagamento.ref}</p>
        <p><b>Entidate:</b> ${proxypay_1.entidadePagamento}</p>
        <p>O valor da Inscrição é 10.000,00 kz</p>
        <p>Referência válida até ${referencia.dataExpiracao.toLocaleString()}</p>

        <p>
          Poderá acompanhar o estado da sua inscrição no consultor de processo 
          do site <a href="https://www.ofa.ao/">www.ofa.ao</a> usando o seu número de inscrição. 
        </p>

        <p><b>Nota:</b> Este e-mail foi gerado automaticamente pela plataforma <b>CNP</b></p>
      `,
            MessageStream: 'outbound',
        });
        res.status(201).json({ msg: 'Pagamento', pagamento });
    }
    catch (err) {
        next(err);
    }
};
exports.payTaxaByReference = payTaxaByReference;
// Controller Para pegar todos os Pagamentos
const getPagamentos = async (req, res, next) => {
    var _a, _b, _c;
    try {
        let { status, ano, mes, dataPagamento, emolumentoId } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObject = {
            $or: [
                { emolumento: '64539e2fe47f4540d1a3ae43' },
                { emolumento: '64539e13e47f4540d1a3ae40' },
            ],
        };
        if (Boolean(status)) {
            filterObject.status = status;
        }
        if (Boolean(ano)) {
            let newAno = parseInt(ano);
            filterObject.updatedAt = (0, main_1.filterByYear)(newAno);
        }
        if (Boolean(ano) && Boolean(mes)) {
            let newAno = parseInt(ano);
            let newMes = parseInt(mes) - 1;
            filterObject.updatedAt = (0, main_1.filterByMonth)(newAno, newMes);
        }
        const total = await pagamento_1.default.find(filterObject).count();
        const pagamentos = await pagamento_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor')
            .sort({ createdAt: -1 });
        for (let p of pagamentos) {
            if (p.comprovativo) {
                p.comprovativo = await (0, aws_1.getURL)(p.comprovativo);
            }
            if (((_a = p.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) && !(0, validate_url_1.default)((_b = p.dadosPessoais) === null || _b === void 0 ? void 0 : _b.fotoURL)) {
                p.dadosPessoais.fotoURL = await (0, aws_1.getURL)(p.dadosPessoais.fotoURL);
            }
            const membro = await membro_1.default.findOne({
                dadosPessoais: (_c = p.dadosPessoais) === null || _c === void 0 ? void 0 : _c.id,
            }).populate('dadosPessoais');
            let pagamento = p;
            if (membro) {
                pagamento.membro = membro;
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            pagamentos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getPagamentos = getPagamentos;
// Controller Para pegar todos os Pagamentos
const getPagamentosAll = async (req, res, next) => {
    var _a, _b;
    try {
        const { status, emolumentoId, tipo, ano, mes, ref } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = {};
        if (Boolean(status)) {
            filterObject.status = status;
        }
        if (Boolean(tipo)) {
            filterObject.tipo = tipo;
        }
        if (Boolean(tipo)) {
            filterObject.tipo = tipo;
        }
        if (Boolean(ref)) {
            filterObject.ref = ref;
        }
        if (Boolean(ano)) {
            let newAno = parseInt(ano);
            filterObject.updatedAt = (0, main_1.filterByYear)(newAno);
        }
        if (Boolean(ano) && Boolean(mes)) {
            let newAno = parseInt(ano);
            let newMes = parseInt(mes) - 1;
            filterObject.updatedAt = (0, main_1.filterByMonth)(newAno, newMes);
        }
        if (Boolean(emolumentoId)) {
            const emolumento = await emolumento_1.default.findById(emolumentoId);
            if (!emolumento) {
                const error = new Error(`Emolumento não encontrado: ${emolumentoId}`);
                error.statusCode = 422;
                throw error;
            }
            filterObject.emolumento = emolumentoId;
        }
        const total = await pagamento_1.default.find(filterObject).count();
        const pagamentos = await pagamento_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor');
        for (let p of pagamentos) {
            if (p.comprovativo) {
                p.comprovativo = await (0, aws_1.getURL)(p.comprovativo);
            }
            if ((_a = p.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
                p.dadosPessoais.fotoURL = await (0, aws_1.getURL)(p.dadosPessoais.fotoURL);
            }
            const membro = await membro_1.default.findOne({
                dadosPessoais: (_b = p.dadosPessoais) === null || _b === void 0 ? void 0 : _b.id,
            }).populate('dadosPessoais');
            let pagamento = p;
            if (membro) {
                pagamento.membro = membro;
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            pagamentos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getPagamentosAll = getPagamentosAll;
const getTaxas = async (req, res, next) => {
    var _a;
    try {
        const { status, ano, mes, dataPagamento } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 10;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObject = {
            $or: [
                { emolumento: '64539e5be47f4540d1a3ae46' },
                { emolumento: '67b623d285393aa569ff4439' },
            ],
        };
        if (Boolean(status)) {
            filterObject.status = status;
        }
        if (Boolean(ano)) {
            filterObject.ano = ano;
        }
        if (Boolean(mes)) {
            filterObject.mes = mes;
        }
        if (Boolean(dataPagamento)) {
            filterObject.updatedAt = { $lte: dataPagamento };
        }
        const total = await pagamento_1.default.find(filterObject).count();
        const pagamentos = await pagamento_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor');
        for (let p of pagamentos) {
            if (p.comprovativo) {
                p.comprovativo = await (0, aws_1.getURL)(p.comprovativo);
            }
            if ((_a = p.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
                p.dadosPessoais.fotoURL = await (0, aws_1.getURL)(p.dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            pagamentos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getTaxas = getTaxas;
// Controller para pegar todos os pagamentos pelos dados PessoaisId
const getByDadosPessoaisId = async (req, res, next) => {
    try {
        const { dadosPessoaisId } = req.params;
        const { status } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObject = {
            dadosPessoais: dadosPessoaisId,
        };
        if (Boolean(status)) {
            filterObject.status = status;
        }
        const dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
        if (!dadosPessoais) {
            const error = new Error('Dados pessoais não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const total = await pagamento_1.default.find(filterObject).count();
        const pagamentos = await pagamento_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor');
        for (let p of pagamentos) {
            if (p.comprovativo) {
                p.comprovativo = await (0, aws_1.getURL)(p.comprovativo);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            pagamentos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getByDadosPessoaisId = getByDadosPessoaisId;
// Controller que pega um único Pagamento
const getPagamento = async (req, res, next) => {
    var _a, _b;
    try {
        const { id } = req.params;
        let referencia;
        const pagamento = await pagamento_1.default.findById(id)
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor')
            .populate('pagamentoReferencia');
        if (!pagamento) {
            const error = new Error('Pagamento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (pagamento.comprovativo) {
            pagamento.comprovativo = await (0, aws_1.getURL)(pagamento.comprovativo);
        }
        if ((_a = pagamento.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
            pagamento.dadosPessoais.fotoURL = await (0, aws_1.getURL)(pagamento.dadosPessoais.fotoURL);
        }
        const membro = await membro_1.default.findOne({
            dadosPessoais: (_b = pagamento.dadosPessoais) === null || _b === void 0 ? void 0 : _b.id,
        }).populate('dadosPessoais');
        let newPagamento = pagamento;
        if (membro) {
            newPagamento.membro = membro;
        }
        if (pagamento.ref) {
            referencia = await referencia_1.default.findOne({ ref: pagamento.ref });
        }
        res.status(200).json({
            msg: 'Sucesso',
            pagamento,
            referencia,
            membro,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getPagamento = getPagamento;
// Controller que pega um único Pagamento
const getPagamentoByRef = async (req, res, next) => {
    var _a, _b;
    try {
        const { ref } = req.params;
        let referencia;
        const pagamento = await pagamento_1.default.findOne({ ref: ref })
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor');
        if (!pagamento) {
            const error = new Error('Pagamento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (pagamento.comprovativo) {
            pagamento.comprovativo = await (0, aws_1.getURL)(pagamento.comprovativo);
        }
        if ((_a = pagamento.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
            pagamento.dadosPessoais.fotoURL = await (0, aws_1.getURL)(pagamento.dadosPessoais.fotoURL);
        }
        const membro = await membro_1.default.findOne({
            dadosPessoais: (_b = pagamento.dadosPessoais) === null || _b === void 0 ? void 0 : _b.id,
        }).populate('dadosPessoais');
        let newPagamento = pagamento;
        if (membro) {
            newPagamento.membro = membro;
        }
        res.status(200).json({ msg: 'Sucesso', pagamento, referencia });
    }
    catch (err) {
        next(err);
    }
};
exports.getPagamentoByRef = getPagamentoByRef;
