"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOneRespostaEmissor = exports.getAllRespostas = void 0;
const resposta_1 = __importDefault(require("../models/resposta"));
const mongoose_1 = __importDefault(require("mongoose"));
const getAllRespostas = async (req, res, next) => {
    try {
        const respostas = await resposta_1.default.find({})
            .populate('pergunta');
        if (respostas.length === 0) {
            return res.status(404).json({
                success: false,
                respostas
            });
        }
        res.status(200).json({
            success: true,
            respostas
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAllRespostas = getAllRespostas;
const getOneRespostaEmissor = async (req, res, next) => {
    try {
        const emissorId = req.params.emissorId;
        const inqueritoId = req.params.inqueritoId;
        const emissorValidId = mongoose_1.default.Types.ObjectId.isValid(emissorId) ? emissorId : null;
        const inqueritoValidId = mongoose_1.default.Types.ObjectId.isValid(inqueritoId) ? inqueritoId : null;
        if (emissorValidId && inqueritoValidId) {
            const respostas = await resposta_1.default.find({ emissor: emissorId })
                .populate({
                path: 'pergunta',
                match: { 'inquerito': inqueritoValidId }, // Filtrar pelo inquérito aqui
            })
                .populate('emissor');
            res.status(200).json({
                success: true,
                respostas
            });
        }
        else {
            return res.status(400).json({
                success: false,
                message: 'Id inválido.'
            });
            //TEST
        }
    }
    catch (err) {
        next(err);
    }
};
exports.getOneRespostaEmissor = getOneRespostaEmissor;
