"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.changeStatus = exports.getSolicitacao = exports.getSolicitacaos = exports.register = void 0;
const express_validator_1 = require("express-validator");
const solicitacao_1 = __importStar(require("../models/solicitacao"));
const pagination_1 = require("../util/pagination");
const user_1 = __importDefault(require("../models/user"));
const main_1 = require("../util/main");
const counter_1 = __importDefault(require("../models/counter"));
const membro_1 = __importDefault(require("../models/membro"));
const emolumento_1 = __importDefault(require("../models/emolumento"));
const financa_1 = require("../util/financa");
const aws_1 = require("../util/aws");
const date_fns_1 = require("date-fns");
const register = async (req, res, next) => {
    try {
        const { membroId, tipo, emolumentoId, efeito } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error(`Membro não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        const emolumento = await emolumento_1.default.findById(emolumentoId);
        if (!emolumento) {
            const error = new Error(`Emolumento não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        // Payment
        const dataExpiracao = (0, date_fns_1.addDays)(new Date((0, main_1.getAngolaTime)()), 3);
        const pagamento = await (0, financa_1.generateReference)(emolumento, membro.dadosPessoais, dataExpiracao, 
        // campo costomizavel
        {
            membroId: membro.id,
            emolumentoId: emolumento.id,
        });
        await pagamento.populate({ path: 'emolumento' });
        // Counter para gerar o numero de sequencia
        const counter = await counter_1.default.findOneAndUpdate({ id: 'Solicitacao' }, { $inc: { seq: 1 } }, { new: true, upsert: true });
        const solicitacao = new solicitacao_1.default({
            membro,
            tipo,
            pagamento,
            numero: counter.seq,
        });
        if (Boolean(efeito)) {
            solicitacao.efeito = efeito;
        }
        await solicitacao.save();
        res.status(201).json({
            msg: 'Sucesso',
            solicitacao,
            pagamento,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.register = register;
const getSolicitacaos = async (req, res, next) => {
    try {
        const { status, membroId, numero, tipo, efeito, count } = req.query;
        let solicitacaos, total;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(status)) {
            filterObj.status = status;
        }
        if (Boolean(membroId)) {
            filterObj.membro = membroId;
        }
        if (Boolean(numero)) {
            filterObj.numero = numero;
        }
        if (Boolean(tipo)) {
            filterObj.tipo = tipo;
        }
        if (Boolean(efeito)) {
            filterObj.efeito = efeito;
        }
        if (Boolean(count) && JSON.parse(count)) {
            total = await solicitacao_1.default.find(filterObj).count();
        }
        else {
            total = await solicitacao_1.default.find(filterObj).count();
            solicitacaos = await solicitacao_1.default.find(filterObj)
                .skip((0, pagination_1.skip)(page, perPage))
                .limit(perPage)
                .populate({
                path: 'membro',
                populate: { path: 'dadosPessoais' },
            })
                .populate({
                path: 'pagamento',
                populate: { path: 'emolumento' },
            })
                .sort((0, main_1.sortBy)(req.query.sortBy || 'createdAt:ASC'));
        }
        res.status(200).json({
            msg: 'Sucesso',
            solicitacaos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getSolicitacaos = getSolicitacaos;
const getSolicitacao = async (req, res, next) => {
    try {
        const { id } = req.params;
        const solicitacao = await solicitacao_1.default.findById(id)
            .populate({
            path: 'membro',
            populate: { path: 'dadosPessoais' },
        })
            .populate({
            path: 'pagamento',
            populate: [{ path: 'referencia' }, { path: 'emolumento' }],
        });
        if (!solicitacao) {
            const error = new Error('Solicitação não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (solicitacao.membro.dadosPessoais) {
            solicitacao.membro.dadosPessoais.fotoURL = await (0, aws_1.getURL)(solicitacao.membro.dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', solicitacao });
    }
    catch (err) {
        next(err);
    }
};
exports.getSolicitacao = getSolicitacao;
const changeStatus = async (req, res, next) => {
    try {
        const { solicitacaoId, status, userId } = req.body;
        let user;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            user = await user_1.default.findById(userId);
            if (!user) {
                const error = new Error(`Admin não encontrado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (!solicitacao_1.solicitacaoStatus.includes(status)) {
            const error = new Error('Status inválido!');
            error.statusCode = 422;
            throw error;
        }
        const solicitacao = await solicitacao_1.default.findById(solicitacaoId)
            .populate({
            path: 'membro',
            populate: { path: 'dadosPessoais' },
        })
            .populate({
            path: 'pagamento',
            populate: { path: 'emolumento' },
        });
        if (!solicitacao) {
            const error = new Error('Solicitação não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (solicitacao.status === 'Aprovado') {
            const error = new Error('Solicitação já aprovada!');
            error.statusCode = 422;
            throw error;
        }
        solicitacao.status = status;
        solicitacao.dataDespacho = new Date();
        if (status === 'Aprovado') {
            solicitacao.dataAprovacao = new Date((0, main_1.getAngolaTime)());
        }
        await solicitacao.save();
        // HistoricoActividade
        await (0, main_1.createHistoricoActividade)(`Alterou solicitacao de renovacao para '${status}'`, 'Solicitacao', solicitacao.id, user);
        if (solicitacao.membro.dadosPessoais) {
            solicitacao.membro.dadosPessoais.fotoURL = await (0, aws_1.getURL)(solicitacao.membro.dadosPessoais.fotoURL);
        }
        res.status(201).json({ msg: 'Sucesso', solicitacao });
    }
    catch (err) {
        next(err);
    }
};
exports.changeStatus = changeStatus;
