"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteUtilizacaoMedicamento = exports.getOneUtilizacaoMedicamento = exports.getAllUtilizacaoMedicamentos = exports.createUtilizacaoMedicamento = void 0;
const express_validator_1 = require("express-validator");
const mongoose_1 = __importDefault(require("mongoose"));
const utilizacaoMedicamento_1 = __importDefault(require("../models/utilizacaoMedicamento"));
const createUtilizacaoMedicamento = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const { tipo, descricao } = req.body;
        const verifyUtilizacaoMedicamento = await utilizacaoMedicamento_1.default.findOne({ tipo });
        if (verifyUtilizacaoMedicamento) {
            const error = new Error(`A Utilizacao de medicamento ${verifyUtilizacaoMedicamento.tipo} já foi criada! `);
            error.statusCode = 422;
            throw error;
        }
        const utilizacaoMedicamento = new utilizacaoMedicamento_1.default({
            tipo,
            descricao
        });
        await utilizacaoMedicamento.save();
        res.status(201).json({
            msg: 'Utilização de medicamento criada com sucesso',
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createUtilizacaoMedicamento = createUtilizacaoMedicamento;
const getAllUtilizacaoMedicamentos = async (req, res, next) => {
    try {
        const utilizacaoMedicamento = await utilizacaoMedicamento_1.default.find();
        if (utilizacaoMedicamento.length === 0) {
            return res.status(404).json({
                success: false,
                message: 'Nenhuma utilização de medicamento encontrada.',
                utilizacaoMedicamento
            });
        }
        res.status(200).json({
            success: true,
            utilizacaoMedicamento
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAllUtilizacaoMedicamentos = getAllUtilizacaoMedicamentos;
const getOneUtilizacaoMedicamento = async (req, res, next) => {
    try {
        const id = req.params.id;
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (validId) {
            const utilizacaoMedicamento = await utilizacaoMedicamento_1.default.findById(id);
            if (!utilizacaoMedicamento) {
                return res.status(404).json({
                    success: false,
                    utilizacaoMedicamento
                });
            }
            res.status(200).json({
                success: true,
                utilizacaoMedicamento
            });
        }
        else {
            return res.status(400).json({
                success: false,
                message: 'Id inválido.'
            });
        }
    }
    catch (err) {
        next(err);
    }
};
exports.getOneUtilizacaoMedicamento = getOneUtilizacaoMedicamento;
const deleteUtilizacaoMedicamento = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const id = req.params.id;
        // Verifica se o id é válido
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (!validId) {
            return res.status(400).json({
                success: false,
                message: 'ID inválido.',
            });
        }
        // Busca o UtilizacaoMedicamento para garantir que ele existe
        const utilizacaoMedicamento = await utilizacaoMedicamento_1.default.findById(id);
        if (!utilizacaoMedicamento) {
            return res.status(404).json({
                success: false,
                message: 'Utilização de medicamento não encontrada.',
            });
        }
        // Deleta o utilizacaoMedicamento
        await utilizacaoMedicamento_1.default.findByIdAndDelete(id);
        res.status(200).json({
            success: true,
            message: `Utilizacão de medicamento ${utilizacaoMedicamento.tipo} deletada com sucesso.`,
        });
    }
    catch (err) {
        next(err); // Passa o erro para o middleware de erro
    }
};
exports.deleteUtilizacaoMedicamento = deleteUtilizacaoMedicamento;
