"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWebAccess = exports.getWebAccesses = exports.registerWebAccess = void 0;
const web_access_1 = __importDefault(require("../models/web-access"));
const express_validator_1 = require("express-validator");
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const pagination_1 = require("../util/pagination");
const aws_1 = require("../util/aws");
const validate_url_1 = __importDefault(require("../util/validate-url"));
const registerWebAccess = async (req, res, next) => {
    try {
        let { dadosPessoaisId, page, country, city, lat, lon, isp, timezone, ip, device, state, road, formatted } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const webAccess = new web_access_1.default({
            country,
            city,
            isp,
            timezone,
            device,
            state,
            road,
            formatted,
            page,
            ip,
        });
        if (Boolean(dadosPessoaisId)) {
            const dados = await dados_pessoais_1.default.findById(dadosPessoaisId);
            if (!dados) {
                const error = new Error('Dados pessoais não encontrado!');
                error.statusCode = 422;
                throw error;
            }
            webAccess.dadosPessoais = dadosPessoaisId;
        }
        if (lat) {
            webAccess.lat = lat;
        }
        if (lon) {
            webAccess.lon = lon;
        }
        await webAccess.save();
        res.status(201).json({ msg: 'Sucesso!', webAccess });
    }
    catch (err) {
        next(err);
    }
};
exports.registerWebAccess = registerWebAccess;
// Funcao Para pegar todos os webAccesss
const getWebAccesses = async (req, res, next) => {
    var _a, _b;
    try {
        const { dadosPessoaisId, country, city, device, operator, pageVisited } = req.query;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(dadosPessoaisId)) {
            filterObj.dadosPessoais = dadosPessoaisId;
        }
        if (Boolean(country)) {
            filterObj.country = country;
        }
        if (Boolean(city)) {
            filterObj.city = city;
        }
        if (Boolean(device)) {
            filterObj.device = device;
        }
        if (Boolean(operator)) {
            filterObj.operator = operator;
        }
        if (Boolean(pageVisited)) {
            filterObj.page = pageVisited;
        }
        const total = await web_access_1.default.find().count(filterObj);
        const webAccesses = await web_access_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('dadosPessoais')
            .sort({ createdAt: -1 });
        for (let webAccess of webAccesses) {
            if (((_a = webAccess === null || webAccess === void 0 ? void 0 : webAccess.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) && !(0, validate_url_1.default)((_b = webAccess === null || webAccess === void 0 ? void 0 : webAccess.dadosPessoais) === null || _b === void 0 ? void 0 : _b.fotoURL)) {
                webAccess.dadosPessoais.fotoURL = await (0, aws_1.getURL)(webAccess.dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            webAccesses,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getWebAccesses = getWebAccesses;
// Funcao que pega uma unico webAccess
const getWebAccess = async (req, res, next) => {
    var _a;
    try {
        const { id } = req.params;
        const webAccess = await web_access_1.default.findById(id);
        if (!webAccess) {
            const error = new Error('WebAccess não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if ((_a = webAccess === null || webAccess === void 0 ? void 0 : webAccess.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
            webAccess.dadosPessoais.fotoURL = await (0, aws_1.getURL)(webAccess.dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', webAccess });
    }
    catch (err) {
        next(err);
    }
};
exports.getWebAccess = getWebAccess;
