"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendEmailPostmark = exports.sendEmail = void 0;
const express_validator_1 = require("express-validator");
const emailer_1 = __importDefault(require("../util/emailer"));
const file_1 = require("../util/file");
const aws_1 = require("../util/aws");
const postmark_1 = __importDefault(require("../services/postmark"));
const sendEmail = async (req, res, next) => {
    var _a;
    try {
        let { from, to, subject, html } = req.body;
        const attachment = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const msg = {
            to,
            from: process.env.SENDER_EMAIL,
            subject,
            html,
            attachments: []
        };
        if (Boolean(from)) {
            msg.from = from;
        }
        if (attachment) {
            attachment.filename = (0, file_1.generateFileName)(attachment);
            await (0, aws_1.uploadFile)(attachment);
            const object = await (0, aws_1.getObjet)(attachment.filename);
            const base64EncodedContent = await ((_a = object.Body) === null || _a === void 0 ? void 0 : _a.transformToString('base64'));
            msg.attachments = [
                {
                    content: base64EncodedContent,
                    filename: attachment.filename,
                    type: attachment.mimetype,
                    disposition: "attachment"
                }
            ];
        }
        await emailer_1.default.send(msg);
        res
            .status(201)
            .json({ msg: 'Sucesso' });
    }
    catch (err) {
        next(err);
    }
};
exports.sendEmail = sendEmail;
const sendEmailPostmark = async (req, res, next) => {
    var _a;
    try {
        let { From, To, Subject, HtmlBody, TextBody, MessageStream } = req.body;
        const attachment = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const msg = {
            From: process.env.SENDER_EMAIL,
            To,
            Subject,
            HtmlBody,
            TextBody,
            MessageStream: 'outbound',
            Attachments: []
        };
        if (Boolean(From)) {
            msg.From = From;
        }
        if (Boolean(MessageStream)) {
            msg.MessageStream = MessageStream;
        }
        if (attachment) {
            attachment.filename = (0, file_1.generateFileName)(attachment);
            await (0, aws_1.uploadFile)(attachment);
            const object = await (0, aws_1.getObjet)(attachment.filename);
            const base64EncodedContent = await ((_a = object.Body) === null || _a === void 0 ? void 0 : _a.transformToString('base64'));
            msg.Attachments = [
                {
                    Content: base64EncodedContent,
                    Name: attachment.filename,
                    ContentType: attachment.mimetype,
                    ContentID: null
                }
            ];
        }
        await postmark_1.default.sendEmail(msg);
        res
            .status(201)
            .json({ msg: 'Sucesso' });
    }
    catch (err) {
        next(err);
    }
};
exports.sendEmailPostmark = sendEmailPostmark;
