"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const userSchema = new mongoose_1.Schema({
    imagem: {
        type: String,
    },
    titulo: {
        type: String,
    },
    descricao: {
        type: String,
    },
    status: {
        type: String,
        enum: ['Activo', 'Inactivo'],
        default: 'Activo'
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User'
    },
    dataDespacho: {
        type: Date,
        default: new Date(),
    }
}, { timestamps: true });
const Carousel = (0, mongoose_1.model)('Carousel', userSchema);
exports.default = Carousel;
