"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.comunicadoStatus = void 0;
const mongoose_1 = require("mongoose");
exports.comunicadoStatus = ['Activo', 'Inactivo'];
const comunicadoSchema = new mongoose_1.Schema({
    titulo: {
        type: String,
    },
    conteudo: {
        type: String,
    },
    status: {
        type: String,
        enum: exports.comunicadoStatus,
        default: 'Activo'
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin'
    },
    editadoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin'
    },
}, { timestamps: true });
const Comunicado = (0, mongoose_1.model)('Comunicado', comunicadoSchema);
exports.default = Comunicado;
