"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const experienciaProfissionalSchema = new mongoose_1.Schema({
    instituicao: {
        type: String,
    },
    sector: {
        type: String,
    },
    mesInicio: {
        type: Number,
    },
    anoInicio: {
        type: Number,
    },
    mesTermino: {
        type: Number,
    },
    anoTermino: {
        type: Number,
    },
    cargo: {
        type: String,
    },
    descricao: {
        type: String,
    },
    tel1: {
        type: String,
    },
    email: {
        type: String,
    },
    // rua: {
    //   type: String,
    // },
    bairro: {
        type: String,
    },
    municipio: {
        type: String,
    },
    provincia: {
        type: String,
    },
    actual: {
        type: Boolean,
    },
    anexo: {
        type: String,
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
}, { timestamps: true });
const ExperienciaProfissional = (0, mongoose_1.model)('ExperienciaProfissional', experienciaProfissionalSchema);
exports.default = ExperienciaProfissional;
