"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const HistoricoProfissionalSchema = new mongoose_1.Schema({
    nomeEmpresa: {
        type: String,
        required: true,
    },
    cargo: {
        type: String,
        required: true,
    },
    dataInicio: {
        type: String,
        required: true,
    },
    dataFim: {
        type: String,
        required: true,
    },
    presente: {
        type: Boolean,
        required: true,
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: 'Membro',
    },
}, { timestamps: true });
exports.default = (0, mongoose_1.model)('HistoricoProfissional', HistoricoProfissionalSchema);
