"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const participanteSchema = new mongoose_1.Schema({
    nome: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
    },
    bi: {
        type: String,
        unique: true
    },
    numeroCarteira: {
        type: String,
    },
    dataNascimento: {
        type: Date,
    },
    profissao: {
        type: String,
    },
    localTrabalho: {
        type: String,
    },
    numero: {
        type: Number,
    },
    genero: {
        type: String,
        required: true,
    },
    telefone1: {
        type: String,
        required: true,
        unique: true,
    },
    telefone2: {
        type: String,
    },
    categoria: {
        type: String,
    },
    ordem: {
        type: String,
    },
    presenca: {
        type: Boolean,
    },
    provincia: {
        type: String,
    },
    municipio: {
        type: String,
    },
    rua: {
        type: String,
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
    evento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Evento',
    },
    inquerito: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Inquerito',
    }
}, { timestamps: true });
const Participante = (0, mongoose_1.model)('Participante', participanteSchema);
exports.default = Participante;
