"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reclamacaoStatus = void 0;
const mongoose_1 = require("mongoose");
exports.reclamacaoStatus = [
    'Análise',
    'Analisado-Secretaria',
    'Analisado-AT',
    'Concluído',
];
const reclamacaoSchema = new mongoose_1.Schema({
    nome: String,
    email: String,
    tel: String,
    assunto: String,
    descricao: String,
    numero: Number,
    anexo1: String,
    anexo2: String,
    status: {
        type: String,
        enum: exports.reclamacaoStatus,
        default: 'Análise',
    },
    dataDespacho: String,
    despachoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User',
    },
    respostas: [
        {
            admin: {
                type: mongoose_1.Schema.Types.ObjectId,
                ref: 'User',
            },
            content: {
                type: String
            },
            data: {
                type: Date
            }
        },
    ],
}, { timestamps: true });
const Reclamacao = (0, mongoose_1.model)('Reclamacao', reclamacaoSchema);
exports.default = Reclamacao;
