"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIO = exports.init = void 0;
const socket_io_1 = require("socket.io");
let io;
const init = (httpServer) => {
    const options = {
        cors: {
            origin: "*",
            methods: ["GET", "POST"]
        }
    };
    io = new socket_io_1.Server(httpServer, options);
    return io;
};
exports.init = init;
const getIO = () => {
    if (!io) {
        throw new Error('Socket.io não inicializado!');
    }
    return io;
};
exports.getIO = getIO;
