"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteFeedback = exports.getFeedback = exports.getFeedbacks = exports.sendFeedback = void 0;
const feedback_1 = __importDefault(require("../models/feedback"));
const express_validator_1 = require("express-validator");
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const pagination_1 = require("../util/pagination");
const aws_1 = require("../util/aws");
const user_1 = __importDefault(require("../models/user"));
const sendFeedback = async (req, res, next) => {
    try {
        let { assunto, descricao, dadosPessoaisId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        let dadosPessoais;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(dadosPessoaisId)) {
            dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
            if (!dadosPessoais) {
                const error = new Error(`Dados Pessoais não encontrado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        const feedback = new feedback_1.default({
            assunto,
            descricao,
        });
        if (dadosPessoais) {
            feedback.dadosPessoais = dadosPessoaisId;
        }
        await feedback.save();
        res.status(201).json({ msg: 'Sucesso', feedback });
    }
    catch (err) {
        next(err);
    }
};
exports.sendFeedback = sendFeedback;
const getFeedbacks = async (req, res, next) => {
    var _a;
    try {
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const total = await feedback_1.default.find().count();
        const feedbacks = await feedback_1.default.find()
            .populate('dadosPessoais')
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .sort({ createdAt: -1 });
        for (let feed of feedbacks) {
            if ((_a = feed === null || feed === void 0 ? void 0 : feed.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
                feed.dadosPessoais.fotoURL = await (0, aws_1.getURL)(feed.dadosPessoais.fotoURL);
            }
        }
        res
            .status(200)
            .json({
            msg: 'Sucesso',
            feedbacks,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getFeedbacks = getFeedbacks;
const getFeedback = async (req, res, next) => {
    var _a;
    try {
        const { id } = req.params;
        const feedback = await feedback_1.default.findById(id)
            .populate('dadosPessoais');
        if (!feedback) {
            const error = new Error('Feedback não encontrado');
            error.statusCode = 422;
            throw error;
        }
        if ((_a = feedback === null || feedback === void 0 ? void 0 : feedback.dadosPessoais) === null || _a === void 0 ? void 0 : _a.fotoURL) {
            feedback.dadosPessoais.fotoURL = await (0, aws_1.getURL)(feedback.dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', feedback });
    }
    catch (err) {
        next(err);
    }
};
exports.getFeedback = getFeedback;
const deleteFeedback = async (req, res, next) => {
    try {
        const { feedbackId, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Feedback não encontrado');
            error.statusCode = 422;
            throw error;
        }
        await feedback_1.default.findByIdAndRemove(feedbackId);
        res.status(204);
    }
    catch (err) {
        next(err);
    }
};
exports.deleteFeedback = deleteFeedback;
