"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.conprovativoPagamento = void 0;
const express_validator_1 = require("express-validator");
const puppeteer_1 = __importDefault(require("puppeteer"));
const pagamento_1 = __importDefault(require("../models/pagamento"));
// const ejs = require('ejs');
// const path = require('path');
const ejs_1 = __importDefault(require("ejs"));
const path_1 = __importDefault(require("path"));
const conprovativoPagamento = async (req, res, next) => {
    var _a, _b, _c;
    try {
        let { idPagamento } = req.params;
        const errors = (0, express_validator_1.validationResult)(req);
        const pagamento = await pagamento_1.default.findById(idPagamento)
            .populate('referencia')
            .populate('emolumento')
            .populate({
            path: 'dadosPessoais',
        })
            .populate('aprovadoPor')
            .populate('pagamentoReferencia');
        if (!pagamento) {
            const error = new Error(`Pagamento não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        const browser = await puppeteer_1.default.launch();
        const page = await browser.newPage();
        // Renderiza o template EJS com os dados dinâmicos
        //  const criacaoRef = pagamento.updatedAt.substring(0, 10).split('-').reverse().join('/');
        //  const dataPagamento = pagamento.createdAt.substring(0, 10).split('-').reverse().join('/');
        const dataCriacaoRef = pagamento.updatedAt;
        const dataPagamento = pagamento.createdAt;
        const nome = (_a = pagamento.dadosPessoais) === null || _a === void 0 ? void 0 : _a.nome;
        const emolumento = (_b = pagamento.emolumento) === null || _b === void 0 ? void 0 : _b.designacao;
        const montante = (_c = pagamento.referencia) === null || _c === void 0 ? void 0 : _c.montante;
        const ano = pagamento.ano;
        //  const mes = meses[parseInt(pagamento.mes)];
        const mes = pagamento.mes;
        const referencia = (pagamento === null || pagamento === void 0 ? void 0 : pagamento.ref) ? pagamento.ref : "-";
        //  const status = pagamento.referencia.status;
        const status = pagamento.status;
        const html = await ejs_1.default.renderFile(path_1.default.join(__dirname, 'pdf', 'comprovativo-pagamento.ejs'), { dataCriacaoRef, dataPagamento, nome, emolumento, montante, ano, mes, referencia, status });
        await page.setContent(html);
        // Gerar PDF
        const pdf = await page.pdf({ format: 'A4' });
        // Fechar o navegador
        await browser.close();
        // Configurar resposta
        res.setHeader('Content-Type', 'application/pdf');
        res.setHeader('Content-Disposition', `attachment; filename=comprovativo${pagamento.ref}.pdf`);
        // Enviar PDF para o cliente  
        res.status(201).end(pdf);
        // res.sendFile() 
        // res.status(201).json({ msg: 'Sucesso', pdf });
    }
    catch (err) {
        next(err);
    }
};
exports.conprovativoPagamento = conprovativoPagamento;
