"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMenuEventos = exports.getMenuProcessosInscricao = exports.getMenuPrincipal = void 0;
const membro_1 = __importDefault(require("../models/membro"));
const solicitacao_1 = __importDefault(require("../models/solicitacao"));
const mesa_redonda_1 = __importDefault(require("../models/mesa-redonda"));
const evento_1 = __importDefault(require("../models/evento"));
const assembleia_constitutiva_1 = __importDefault(require("../models/assembleia-constitutiva"));
const reclamacao_1 = __importDefault(require("../models/reclamacao"));
const getMenuPrincipal = async (req, res, next) => {
    try {
        let direccao = Array.isArray(req.query.direccao) ? req.query.direccao[0] : req.query.direccao;
        direccao = typeof direccao === 'string' ? direccao : '';
        const filter = direccao && !['CNP', 'Coordenador', 'Bastónario'].includes(direccao) ? { direccao } : {};
        const inscricoesGeral = await membro_1.default.find({ approved: false, ...filter }).count();
        const atualizacoesDados = await membro_1.default.find({ campanha: true, ...filter }).count();
        const solicitacoes = await solicitacao_1.default.find({}).count();
        const membros = await membro_1.default.find({ status: 'Activo', ...filter }).count();
        const eventos = await evento_1.default.find({}).count();
        const reclamacoes = await reclamacao_1.default.find({ status: 'Análise' }).count();
        res.status(200).json({
            msg: 'Sucesso',
            membros,
            inscricoesGeral,
            solicitacoes,
            atualizacoesDados,
            eventos,
            reclamacoes,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getMenuPrincipal = getMenuPrincipal;
const getMenuProcessosInscricao = async (req, res, next) => {
    try {
        let direccao = Array.isArray(req.query.direccao) ? req.query.direccao[0] : req.query.direccao;
        direccao = typeof direccao === 'string' ? direccao : '';
        const filter = direccao && !['CNP', 'Coordenador', 'Bastónario'].includes(direccao) ? { direccao } : {};
        const secretaria = await membro_1.default.find({ approved: false, status: 'Análise', ...filter }).count();
        const areaTecnica = await membro_1.default.find({ approved: false, status: 'Analisado-Secretaria', ...filter }).count();
        const bastonario = await membro_1.default.find({ approved: false, status: 'Analisado-AT', ...filter }).count();
        const indeferidos = await membro_1.default.find({ approved: false, status: 'Reprovado', ...filter }).count();
        res.status(200).json({
            msg: 'Sucesso',
            secretaria,
            areaTecnica,
            bastonario,
            indeferidos,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getMenuProcessosInscricao = getMenuProcessosInscricao;
const getMenuEventos = async (req, res, next) => {
    try {
        let { direccao } = req.query;
        // const eventos = await Evento.find({ status: 'Análise'}).count();
        const mesaRedonda = await mesa_redonda_1.default.find({}).count();
        const assembleiaConstitutiva = await assembleia_constitutiva_1.default.find({}).count();
        res.status(200).json({
            msg: 'Sucesso',
            mesaRedonda,
            assembleiaConstitutiva,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getMenuEventos = getMenuEventos;
