"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tipoDadosAcademicos = void 0;
const mongoose_1 = require("mongoose");
exports.tipoDadosAcademicos = [
    'Licenciatura',
    'Pós-Graduação',
    'Mestrado',
    'Especialidade',
    'Doutoramento',
    'Baixarel', // Remover quando o jonilson fizer a implementacao no front
    'Bacharel',
    'Técnico-Médio',
    'Técnico-Básico',
];
const dadosAcademicoSchema = new mongoose_1.Schema({
    instituicao: {
        type: String,
    },
    curso: {
        type: String,
    },
    tipo: {
        type: String,
        enum: exports.tipoDadosAcademicos,
    },
    anoInicio: {
        type: Number,
    },
    mesInicio: {
        type: Number,
    },
    anoFim: {
        type: Number,
    },
    mesFim: {
        type: Number,
    },
    cidade: {
        type: String,
    },
    pais: {
        type: String,
    },
    anexo: {
        type: String,
    },
    nota: {
        type: String,
    },
    descricao: {
        type: String,
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
}, { timestamps: true });
const DadosAcademico = (0, mongoose_1.model)('DadosAcademico', dadosAcademicoSchema);
exports.default = DadosAcademico;
