"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const formaFarmaceuticaSchema = new mongoose_1.Schema({
    titulo: {
        type: String,
        required: true
    },
    descricao: {
        type: String,
        required: true
    },
    status: {
        type: Boolean,
        default: true
    },
    tipoFormaFarmaceutica: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'TipoFormaFarmaceutica',
        required: true,
    },
}, { timestamps: true });
const FormaFarmaceutica = (0, mongoose_1.model)('FormaFarmaceutica', formaFarmaceuticaSchema);
exports.default = FormaFarmaceutica;
