"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.membroDireccao = exports.membroStatus = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const main_1 = require("../util/main");
exports.membroStatus = [
    'Análise',
    'Aprovado',
    'Analisado-Secretaria',
    'Analisado-AT',
    'Aprovado-Presidente',
    'Reprovado',
    'Indeferido',
    'Activo',
    'Inactivo',
    'Suspenso',
    'Falecido',
];
exports.membroDireccao = ['OFA', 'CAPFA'];
const membroSchema = new mongoose_1.Schema({
    direccao: {
        type: String,
        enum: exports.membroDireccao,
        uppercase: true,
    },
    numeroCarteira: {
        type: String,
    },
    numeroInscricao: {
        type: String,
    },
    numeroInscricaoBeforeTransition: {
        type: String,
    },
    nome: {
        type: String,
    },
    genero: {
        type: String,
    },
    dataInicio: {
        type: Date
    },
    perfil: {
        type: String,
    },
    status: {
        type: String,
        enum: exports.membroStatus,
        default: 'Análise'
    },
    dadosPessoais: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais',
    },
    delegacao: {
        type: String,
    },
    especialidade: {
        type: String,
    },
    provincia: {
        type: String,
    },
    campanha: {
        type: Boolean,
    },
    dataCampanha: {
        type: Date,
    },
    dataDespacho: {
        type: Date,
        default: new Date((0, main_1.getAngolaTime)())
    },
    docs: {
        copiaBI: String,
        diplomaCertificado: String,
        declaracaoInares: String,
    },
    approved: {
        type: Boolean,
        default: false,
    },
    aprovadoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User',
    },
    despachoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User',
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User',
    },
    cnp: {
        type: Boolean,
    },
    online: {
        type: Boolean,
        default: true
    },
    anoConlusao: {
        type: Number
    },
    joia2014: String,
    joia2015: String,
    joia2016: String,
    joia2017: String,
    direcaoTecnica: Number,
    deletedAt: {
        type: Date,
        default: null
    }
}, { timestamps: true });
// // Exclui os deletados das consultas find, findOne, findById
// membroSchema.pre(/^find/, function(next) {
//   this.where({ deletedAt: null });
//   next();
// });
membroSchema.pre(/^find/, function (next) {
    if (this.getOptions().overrideDeleted) {
        return next(); // Não aplica o filtro
    }
    this.where({ deletedAt: null }); // Aplica o filtro normalmente
    next();
});
const Membro = mongoose_1.default.model('Membro', membroSchema);
exports.default = Membro;
