"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const webAccessSchema = new mongoose_1.Schema({
    dadosPessoais: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais'
    },
    page: {
        type: String
    },
    country: {
        type: String
    },
    city: {
        type: String
    },
    lat: {
        type: Number
    },
    lon: {
        type: Number
    },
    timezone: {
        type: Date
    },
    device: {
        type: String
    },
    state: {
        type: String,
    },
    road: {
        type: String,
    },
    formatted: {
        type: String,
    },
    isp: {
        type: String
    },
    ip: {
        type: String
    },
}, { timestamps: true });
const WebAccess = (0, mongoose_1.model)('WebAccess', webAccessSchema);
exports.default = WebAccess;
