"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const file_1 = require("../util/file");
const schemas = __importStar(require("./validation-schemas"));
const noticiaController = __importStar(require("../controllers/noticia"));
const eventoController = __importStar(require("../controllers/evento"));
const inqueritoController = __importStar(require("../controllers/inquerito"));
const respostaController = __importStar(require("../controllers/resposta"));
const painelController = __importStar(require("../controllers/painel"));
const painelEventoController = __importStar(require("../controllers/painel-evento"));
const temaController = __importStar(require("../controllers/tema"));
const perguntaController = __importStar(require("../controllers/pergunta"));
const mesaRedondaController = __importStar(require("../controllers/mesa-redonda"));
const assembleiaConstitutivaController = __importStar(require("../controllers/assembleia-constitutiva"));
const comunicadoController = __importStar(require("../controllers/comunicado"));
const userAdminController = __importStar(require("../controllers/user-admin"));
const dadosPessoaisController = __importStar(require("../controllers/dados-pessoais"));
const membroController = __importStar(require("../controllers/membro"));
const emolumentoController = __importStar(require("../controllers/emolumento"));
const situacaoFinanceiraController = __importStar(require("../controllers/situacao-finaceira"));
const pagamentoController = __importStar(require("../controllers/pagamento"));
const agendaController = __importStar(require("../controllers/agenda"));
const agendamentoController = __importStar(require("../controllers/agendamento"));
const leiController = __importStar(require("../controllers/lei"));
const capituloController = __importStar(require("../controllers/capitulo"));
const artigoController = __importStar(require("../controllers/artigo"));
const historicoActividadeController = __importStar(require("../controllers/historico-actividade"));
const messageController = __importStar(require("../controllers/message"));
const financaController = __importStar(require("../controllers/financa"));
const experienciaProfissionalController = __importStar(require("../controllers/experiencia-profissional"));
const dadosAcademicoController = __importStar(require("../controllers/dados-academico"));
const utilizacaoMedicamentoController = __importStar(require("../controllers/utilizacao-medicamento"));
const feedbackController = __importStar(require("../controllers/feedback"));
const webAccessController = __importStar(require("../controllers/web-access"));
const carouselController = __importStar(require("../controllers/carousel"));
const siteInfoController = __importStar(require("../controllers/site-info"));
const solicitacaoController = __importStar(require("../controllers/solicitacao"));
const carteiraController = __importStar(require("../controllers/carteira"));
const gerarPdfController = __importStar(require("../controllers/gerar-pdf"));
const menusController = __importStar(require("../controllers/menus"));
const docsUploadController = __importStar(require("../controllers/docs-uploads"));
const get_url_1 = __importDefault(require("../middleware/get-url"));
const multer_1 = __importDefault(require("multer"));
const is_auth_1 = __importDefault(require("../middleware/is-auth"));
const send_email_1 = require("../middleware/send-email");
const get_referencia_1 = require("../middleware/get-referencia");
const reclamacaoController = __importStar(require("../controllers/reclamacao"));
const multerConfig = (0, multer_1.default)();
const router = (0, express_1.Router)();
// Membro
router.post('/membro/register', 
// isAuthMiddleware,
(req, res, next) => {
    file_1.upload.fields([
        { name: 'foto', maxCount: 1 },
        { name: 'copiaBI', maxCount: 1 },
        { name: 'diplomaCertificado', maxCount: 1 },
        { name: 'declaracaoInares', maxCount: 1 },
    ])(req, res, function (err) {
        if (err) {
            next(err);
        }
        next();
    });
}, schemas.membroRegister, membroController.registerMembro);
router.post('/membro/become-presidente', is_auth_1.default, schemas.becomePresidente, membroController.becomePresidente);
router.post('/membro/search', is_auth_1.default, schemas.membroSearch, membroController.search);
// router.post(
//   '/membro/search-all',
//   schemas.searchMembro,
//   membroController.searchAll,
// );
router.post('/membro/search/carteira', 
// schemas.searchMembro,
membroController.searchByCarteira);
router.post('/membro/search-inscricao', 
// schemas.searchInscricao,
membroController.searchByNumeroInscricao);
router.patch('/membro/change-status', is_auth_1.default, schemas.changeMembroStatus, membroController.changeMembroStatus);
router.patch('/membro/change-direccao', is_auth_1.default, schemas.membroChangeDireccao, membroController.changeDireccao);
router.get('/membros', is_auth_1.default, membroController.getMembros);
router.get('/membros/campanha', membroController.getMembrosCampanha);
router.get('/membro/:id', 
// isAuthMiddleware,
membroController.getMembro);
router.get('/membro/cv/:id', is_auth_1.default, membroController.getCV);
router.patch('/membro/add-especialidade', 
// isAuthMiddleware,
schemas.addEspecialidade, membroController.addEspecialidade);
// router.post(
//   '/membro/insert',
//   isAuthMiddleware,
//   upload.single('foto'),
//   schemas.insert,
//   membroController.insertMembro,
// );
// router.post(
//   '/membro/insert-membro-cnp',
//   isAuthMiddleware,
//   schemas.insertMembroCNP,
//   membroController.insertMembroCNP,
// );
router.post('/membro/insert-from-excel', 
// isAuthMiddleware,
multerConfig.single('file'), membroController.insertFromExcel);
router.post('/membro/ano-conclusao-from-excel', 
// isAuthMiddleware,
multerConfig.single('file'), membroController.getAnoConclusaoFromExcel);
router.delete('/membro/delete', is_auth_1.default, schemas.membroDelete, membroController.deleteMembro);
router.post('/membro/restore', is_auth_1.default, schemas.membroDelete, membroController.restoreMembro);
router.patch('/membro/approve-final', is_auth_1.default, schemas.membroApproveFinal, membroController.approveFinal);
router.patch('/membro/edit-doc', 
// isAuthMiddleware,
file_1.upload.single('doc'), schemas.membroEditDoc, membroController.editDoc);
router.post('/membro/verificar/:bi', 
// isAuthMiddleware,
schemas.verifyBi, membroController.searchMembroBi);
router.post('/membro/confirm-actualizacao-dados', 
// isAuthMiddleware,
membroController.confirmActualizacaoDadosMembro);
//FIM Actualizacao de dados membros
router.put('/carteira/modify', 
// isAuthMiddleware,
membroController.alteracaoCarteira);
// Fim Membro
// Solicitacao
router.post('/solicitacao/register', is_auth_1.default, schemas.solicitacaoRegister, solicitacaoController.register);
router.get('/solicitacaos', is_auth_1.default, solicitacaoController.getSolicitacaos);
router.get('/solicitacao/:id', is_auth_1.default, solicitacaoController.getSolicitacao);
router.patch('/solicitacao/change-status', is_auth_1.default, schemas.solicitacaoChangeStatus, solicitacaoController.changeStatus);
// Fim Solicitacao
// Agenda
router.post('/agenda/create', is_auth_1.default, schemas.createAgenda, agendaController.createAgenda);
router.get('/agendas', is_auth_1.default, agendaController.getAgendas);
router.get('/agendas/membro/:membroId', is_auth_1.default, agendaController.getAgendasByMembro);
router.get('/agenda/:id', is_auth_1.default, agendaController.getAgenda);
router.delete('/agenda/delete', is_auth_1.default, schemas.deleteAgenda, agendaController.deleteAgenda);
// Fim Agenda
// Agendamento
router.post('/agendamento/create', is_auth_1.default, schemas.createAgendamento, agendamentoController.createAgendamento);
// Fim Agendamento
// Pagamento
router.post('/pagamento/quota-by-reference', is_auth_1.default, schemas.payQuotaByReference, pagamentoController.payQuotaByReference);
router.post('/pagamento/taxa-by-reference', is_auth_1.default, schemas.payTaxaByReference, pagamentoController.payTaxaByReference);
router.post('/pagamento/reference', 
// isAuthMiddleware,
// schemas.payTaxaByReference,
pagamentoController.payByReference);
router.post('/api/v2/payments/proxypay', 
// schemas.payCotaByReference,
pagamentoController.postPaymentProxyPay);
router.get('/pagamentos', is_auth_1.default, pagamentoController.getPagamentos);
router.get('/pagamentos/all', is_auth_1.default, pagamentoController.getPagamentosAll);
router.get('/pagamentos/taxa-inscricao', is_auth_1.default, pagamentoController.getTaxas);
router.get('/pagamentos/dados-pessoais/:dadosPessoaisId', 
// isAuthMiddleware,
pagamentoController.getByDadosPessoaisId);
router.get('/pagamento/:id', is_auth_1.default, pagamentoController.getPagamento);
router.get('/pagamento/referencia/:ref', pagamentoController.getPagamentoByRef);
router.get('/pagamento/referencias', is_auth_1.default, pagamentoController.getPagamento);
// Fim Pagamento
// Referencia
router.get('/referencias', is_auth_1.default, get_referencia_1.getReferencia);
// Fim Referencia
// SituacaoFinanceira
router.post('/situacao-financeira/create', is_auth_1.default, schemas.createSituacaoFinanceira, situacaoFinanceiraController.createSituacaoFinanceira);
router.get('/situacao-financeiras/', is_auth_1.default, situacaoFinanceiraController.getSFs);
router.get('/situacao-financeira/:id', is_auth_1.default, situacaoFinanceiraController.getSF);
router.get('/situacao-financeira/membro/:membroId', is_auth_1.default, situacaoFinanceiraController.getSFsByMembro);
// Rota para remover duplicatas de situação financeira do ano 2025
router.delete('/situacao-financeira/remove-duplicados', is_auth_1.default, situacaoFinanceiraController.removerDuplicados);
// Fim SituacaoFinanceira
// Financa
router.post('/financa/saida/create', is_auth_1.default, schemas.saidaCreate, financaController.createSaida);
router.get('/financa/fechos', is_auth_1.default, financaController.getFechos);
router.get('/financa/fecho/:id', is_auth_1.default, financaController.getFecho);
router.get('/financa/saidas', is_auth_1.default, financaController.getSaidas);
router.get('/financa/saida/:id', is_auth_1.default, financaController.getSaida);
// Fim Financa
// Emolumento
router.post('/emolumento/create', is_auth_1.default, schemas.createEmolumento, emolumentoController.createEmolumento);
router.get('/emolumentos', emolumentoController.getEmolumentos);
router.get('/emolumento/:id', emolumentoController.getEmolumento);
// Fim Emolumento
// DadosPessoais
router.put('/dados-pessoais/edit', 
// isAuthMiddleware,
schemas.dadosPessoaisEdit, dadosPessoaisController.editDadosPessoais);
router.patch('/dados-pessoais/edit-foto', 
// isAuthMiddleware,
file_1.upload.single('foto'), dadosPessoaisController.editFoto);
// Fim DadosPessoais
// Message / Chat - Funcionalidade CNP Carteira Digital
router.post('/message/send/admin-to-membro', is_auth_1.default, schemas.sendMessageAdminToMembro, messageController.sendMessageAdminToMembro);
router.post('/message/send/membro-to-admin', is_auth_1.default, schemas.sendMessageMembroToAdmin, messageController.sendMessageMembroToAdmin);
router.get('/messages/:dadosPessoaisId', is_auth_1.default, messageController.getMembroAdminMessages);
router.get('/message/membros-chat', is_auth_1.default, messageController.getMembrosChat);
router.patch('/message/view', is_auth_1.default, schemas.messageView, messageController.viewMessage);
// Fim Message / Chat
// Feedback
router.post('/feedback/send', schemas.feedbackSend, feedbackController.sendFeedback);
router.get('/feedbacks', is_auth_1.default, feedbackController.getFeedbacks);
router.get('/feedback/:id', is_auth_1.default, feedbackController.getFeedback);
router.delete('/feedback/delete', is_auth_1.default, schemas.feedbackDelete, feedbackController.deleteFeedback);
// Fim Feedback
// ExperienciaProfissional
router.post('/experiencia-profissional/create', file_1.upload.single('anexo'), schemas.experienciaProfissionalCreate, experienciaProfissionalController.createExperienciaProfissional);
router.get('/experiencia-profissional/:id', is_auth_1.default, experienciaProfissionalController.getExperienciaProfissional);
router.get('/experiencia-profissionais/membro/:membroId', 
// isAuthMiddleware,
experienciaProfissionalController.getExperienciasProfissionaisByMembro);
router.put('/experiencia-profissional/edit', 
// isAuthMiddleware,
schemas.editExperienciaProfissional, experienciaProfissionalController.editExperienciaProfissional);
router.delete('/experiencia-profissional/delete', is_auth_1.default, schemas.deleteExperienciaProfissional, experienciaProfissionalController.deletePermante);
// Fim ExperienciaProfissional
// DadosAcademicos
router.post('/dados-academico/create', file_1.upload.single('anexo'), schemas.dadosAcademicoCreate, dadosAcademicoController.createDadosAcademico);
router.get('/dados-academico/:id', is_auth_1.default, dadosAcademicoController.getDadosAcademico);
router.get('/dados-academico/membro/:membroId', 
// isAuthMiddleware,
dadosAcademicoController.getFormacoesAcademicasByMembro);
router.put('/dados-academico/edit', 
// isAuthMiddleware,
schemas.dadosAcademicoEdit, dadosAcademicoController.editDadosAcademico);
router.delete('/dados-academico/delete', is_auth_1.default, schemas.dadosAcademicoDelete, dadosAcademicoController.deletePermante);
// Fim DadosAcademicos
// Noticia
router.post('/noticia/create', is_auth_1.default, file_1.upload.single('imagem'), schemas.createNoticia, noticiaController.createNoticia);
router.get('/noticias', noticiaController.getNoticias);
router.get('/noticia/:id', noticiaController.getNoticia);
router.put('/noticia/edit', is_auth_1.default, schemas.editNoticia, noticiaController.editNoticia);
router.patch('/noticia/change-imagem', is_auth_1.default, file_1.upload.single('imagem'), noticiaController.changeImage);
router.delete('/noticia/delete', is_auth_1.default, schemas.deleteSchema, noticiaController.deleteNoticia);
// Fim Noticia
// DocsUpload
router.post('/doc-upload/create', is_auth_1.default, file_1.upload.single('anexo'), schemas.docUploadCreate, docsUploadController.createDoc);
router.get('/docs-upload', docsUploadController.getDocsUpload);
router.get('/doc-upload/:id', docsUploadController.getDocUpload);
router.put('/doc-upload/edit', is_auth_1.default, schemas.docUploadEdit, docsUploadController.editDocUpload);
router.patch('/doc-upload/change-doc', is_auth_1.default, file_1.upload.single('anexo'), schemas.docUploadChangeImage, docsUploadController.changeImage);
router.delete('/doc-upload/delete', is_auth_1.default, schemas.deleteSchema, docsUploadController.deleteDocUpload);
// Fim DocsUpload
// Inqueritos
router.post('/inquerito/create', 
// isAuthMiddleware,
schemas.createInquerito, inqueritoController.createInquerito);
router.get('/inquerito', 
//isAuthMiddleware,
inqueritoController.getAllInqueritos);
router.get('/inquerito/:id', 
//isAuthMiddleware,
inqueritoController.getOneInquerito);
router.get('/inquerito/:nome/:tituloEvento', 
//isAuthMiddleware,
schemas.getInqueritoEvento, inqueritoController.getInqueritoEvento);
router.delete('/inquerito/:id', 
//isAuthMiddleware,
schemas.paramIdInquerito, inqueritoController.deleteInquerito);
// Fim Inquerito
// Respostas
router.get('/respostas', 
//isAuthMiddleware,
respostaController.getAllRespostas);
router.post('/respostas/create', 
//isAuthMiddleware,
schemas.createRespostaInquerito, inqueritoController.createRespostaInquerito);
router.get('/respostas/:inqueritoId/:emissorId', 
//isAuthMiddleware,
respostaController.getOneRespostaEmissor);
// Fim Respostas
// Perguntas
router.get('/perguntas', 
//isAuthMiddleware,
perguntaController.getAllPerguntas);
router.get('/perguntas/:id', 
//isAuthMiddleware,
schemas.paramIdPergunta, perguntaController.getOnePergunta);
router.post('/perguntas/create', 
// isAuthMiddleware,
schemas.createPergunta, perguntaController.createPergunta);
router.delete('/perguntas/:id', 
//isAuthMiddleware,
schemas.paramIdPergunta, perguntaController.deletePergunta);
// Fim Perguntas
// Paineis
router.get('/paineis', 
//isAuthMiddleware,
painelController.getAllPaineis);
router.get('/paineis/:id', 
//isAuthMiddleware,
schemas.paramIdPainel, painelController.getOnePainel);
router.post('/paineis/create', 
// isAuthMiddleware,
schemas.createPainel, painelController.createPainel);
router.delete('/paineis/:id', 
//isAuthMiddleware,
schemas.paramIdPainel, painelController.deletePainel);
// Fim Paineis
// Eventos
router.post('/envento/create', 
// isAuthMiddleware,
file_1.upload.single('imagem'), schemas.createEvento, eventoController.createEvento);
router.get('/eventos', 
//isAuthMiddleware,
eventoController.getAllEvento);
router.get('/evento/:id', 
//isAuthMiddleware,
eventoController.getOneEvento);
// Fim eventos
// Paineis Evento
router.get('/painelEvento', 
//isAuthMiddleware,
painelEventoController.getAllPainelEventos);
router.get('/painelEvento/:id', 
//isAuthMiddleware,
schemas.getOnePainelEvento, painelEventoController.getOnePainelEvento);
router.post('/painelEvento/create', 
// isAuthMiddleware,
schemas.createPainelEvento, painelEventoController.createPainelEvento);
router.post('/painelEvento/adicionarTema', 
// isAuthMiddleware,
schemas.addTemaPainelEvento, painelEventoController.adicionarTemaPainelEvento);
router.delete('/painelEvento/:id', 
//isAuthMiddleware,
schemas.getOnePainelEvento, painelEventoController.deletePainelEvento);
// Fim Paineis Evento
// Tema
router.get('/temas', 
//isAuthMiddleware,
temaController.getAllTemas);
router.get('/temas/:id', 
//isAuthMiddleware,
schemas.paramIdTema, temaController.getOneTema);
router.post('/temas/create', 
// isAuthMiddleware,
schemas.createTema, temaController.createTema);
router.delete('/temas/:id', 
//isAuthMiddleware,
schemas.getOnePainelEvento, temaController.deleteTema);
// Fim Tema
// Mesa redonda
router.post('/evento/mesa-redonda/register', 
// schemas.mesaRedondaRegister,
mesaRedondaController.register);
router.get('/eventos/mesa-redonda', 
// isAuthMiddleware,
mesaRedondaController.getMesaRedondas);
router.get('/evento/mesa-redonda/:id', is_auth_1.default);
router.patch('/evento/mesa-redonda/confirm-presenca/:id', is_auth_1.default, mesaRedondaController.mesaRedondaConfirmPresenca);
// Fim Mesa redonda
// Assembleia Constitutiva
router.post('/assembleia-constitutiva/register', schemas.assembleiaConstitutivaInscricao, assembleiaConstitutivaController.inscricao);
router.post('/assembleia-constitutiva/capfa/register', (req, res, next) => {
    file_1.upload.fields([
        // { name: 'foto', maxCount: 1 },
        { name: 'copiaBI', maxCount: 1 },
        { name: 'diplomaCertificado', maxCount: 1 },
        { name: 'copiaReconhecimentoME', maxCount: 1 },
    ])(req, res, function (err) {
        if (err) {
            next(err);
        }
        next();
    });
}, schemas.assembleiaConstitutivaInscricao, assembleiaConstitutivaController.inscricaoCapfa);
router.get('/assembleia-constitutiva/inscricoes', is_auth_1.default, assembleiaConstitutivaController.getInscricoes);
router.get('/assembleia-constitutiva/inscricao/:id', is_auth_1.default);
router.patch('/assembleia-constitutiva/confirm-presenca/:id', is_auth_1.default, assembleiaConstitutivaController.confirmPresenca);
// Candidados
router.post('/assembleia-constitutiva/create-candidato', is_auth_1.default, file_1.upload.single('imagem'), 
// schemas.docUploadCreate,
assembleiaConstitutivaController.createCandidadto);
router.get('/assembleia-constitutiva/candidatos', assembleiaConstitutivaController.getCandidadtos);
router.get('/assembleia-constitutiva/candidato/:id', assembleiaConstitutivaController.getCandidadto);
// voto
router.post('/assembleia-constitutiva/create-voto', 
// isAuthMiddleware,
// schemas.docUploadCreate,
assembleiaConstitutivaController.createVoto);
router.get('/assembleia-constitutiva/votos', assembleiaConstitutivaController.getVotos);
// router.get('/assembleia-constitutiva/candidato/:id', assembleiaConstitutivaController.getVoto);
router.post('/vericar/votante', 
// isAuthMiddleware,
schemas.verifyBi, assembleiaConstitutivaController.searchVotante);
// Assembleia Constitutiva
// Comunicado
router.post('/comunicado/create', is_auth_1.default, schemas.createComunicado, comunicadoController.createComunicado);
router.get('/comunicados', is_auth_1.default, comunicadoController.getComunicados);
router.get('/comunicado/:id', is_auth_1.default, comunicadoController.getComunicado);
router.put('/comunicado/edit', is_auth_1.default, schemas.editComunicado, comunicadoController.editComunicado);
router.patch('/comunicado/change-status', is_auth_1.default, schemas.changeComunicadoStatus, comunicadoController.changeStatus);
router.delete('/comunicado/delete', is_auth_1.default, schemas.deleteComunicado, comunicadoController.deleteComunicado);
// Fim Comunicado
// UserAdmin / Rota CNP-GEST
router.post('/admin/create', is_auth_1.default, file_1.upload.single('foto'), schemas.createUserAdmin, userAdminController.registerUserAdmin);
router.post('/admin/make-membro-admin', is_auth_1.default, schemas.makeMembroAdmin, userAdminController.makeMembroAdmin);
router.get('/admin/cnp', is_auth_1.default, userAdminController.getFuncionarios);
router.get('/admin/cnp/:id', is_auth_1.default, userAdminController.getFuncionarios);
router.get('/admin/funcionarios', is_auth_1.default, userAdminController.getFuncionarios);
router.get('/admin/funcionario/:id', is_auth_1.default, userAdminController.getFuncionario);
router.patch('/admin/funcionario/change-status', is_auth_1.default, schemas.changeFuncinarioStatus, userAdminController.changeFuncionarioStatus);
// router.get('/admin/honorios', isAuthMiddleware, userAdminController.getHonorios);
router.get('/admin/honorios', userAdminController.getHonorios);
router.patch('/admin/edit-assinatura', is_auth_1.default, file_1.upload.single('assinatura'), userAdminController.editAssinatura);
router.patch('/admin/edit-carimbo', is_auth_1.default, file_1.upload.single('carimbo'), userAdminController.editCarimbo);
// Fim UserAdmin
// Lei
router.post('/lei/create', is_auth_1.default, schemas.registerLei, leiController.registerLei);
router.post('/lei/search-numero', is_auth_1.default, schemas.searchLeiByNumero, leiController.searchLeiByNumero);
router.get('/leis', is_auth_1.default, leiController.getLeis);
router.get('/lei/:id', is_auth_1.default, leiController.getLei);
router.patch('/lei/edit', is_auth_1.default, schemas.editLei, leiController.editLei);
router.delete('/lei/delete', is_auth_1.default, schemas.deleteLei, leiController.deleteLei);
// Fim Lei
// Capitulo
router.post('/capitulo/create', is_auth_1.default, schemas.registerCapitulo, capituloController.registerCapitulo);
router.post('/capitulos/search', is_auth_1.default, schemas.searchCapitulos, capituloController.searchCapitulos);
router.post('/capitulo/search-numero', is_auth_1.default, schemas.searchCapituloByNumero, capituloController.searchCapituloByNumero);
router.get('/capitulos', is_auth_1.default, capituloController.getCapitulos);
router.get('/capitulo/:id', is_auth_1.default, capituloController.getCapitulo);
router.patch('/capitulo/edit', is_auth_1.default, schemas.editCapitulo, capituloController.editCapitulo);
router.delete('/capitulo/delete', is_auth_1.default, schemas.deleteCapitulo, capituloController.deleteCapitulo);
// Fim Capitulo
// Artigo
router.post('/artigo/create', is_auth_1.default, schemas.registerArtigo, artigoController.registerArtigo);
router.post('/artigos/search', is_auth_1.default, schemas.searchArtigos, artigoController.searchArtigos);
router.post('/artigo/search-numero', is_auth_1.default, schemas.searchArtigoByNumero, artigoController.searchArtigoByNumero);
router.get('/artigos', is_auth_1.default, artigoController.getArtigos);
router.get('/artigos/capitulo/:capituloId', is_auth_1.default, artigoController.getArtigosByCapitulo);
router.get('/artigo/:id', is_auth_1.default, artigoController.getArtigo);
router.patch('/artigo/edit', is_auth_1.default, schemas.editArtigo, artigoController.editArtigo);
router.delete('/artigo/delete', is_auth_1.default, schemas.deleteArtigo, artigoController.deleteArtigo);
// Fim Artigo
// Carousel
router.post('/carousel/create', is_auth_1.default, file_1.upload.single('imagem'), schemas.carouselCreate, carouselController.createCarousel);
router.get('/carousels', carouselController.getCarousels);
router.get('/carousel/:id', carouselController.getCarousel);
router.put('/carousel/edit', is_auth_1.default, schemas.carouselEdit, carouselController.editCarousel);
router.patch('/carousel/change-imagem', is_auth_1.default, file_1.upload.single('imagem'), schemas.carouselChangeImage, carouselController.changeImage);
router.delete('/carousel/delete', is_auth_1.default, schemas.deleteSchema, carouselController.deleteCarousel);
// Fim Carousel
// SiteInfo
router.post('/site-info/create', is_auth_1.default, file_1.upload.single('imagem'), schemas.siteInfoCreate, siteInfoController.createSiteInfo);
router.get('/site-infos', siteInfoController.getSiteInfos);
router.get('/site-info/:id', siteInfoController.getSiteInfo);
router.put('/site-info/edit', is_auth_1.default, schemas.siteInfoEdit, siteInfoController.editSiteInfo);
router.patch('/site-info/change-imagem', is_auth_1.default, file_1.upload.single('imagem'), schemas.siteInfoChangeImage, siteInfoController.changeImage);
router.delete('/site-info/delete', is_auth_1.default, schemas.deleteSchema, siteInfoController.deleteSiteInfo);
// Fim SiteInfo
// Carteira
router.get('/carteiras', is_auth_1.default, carteiraController.getCarteiras);
router.get('/carteira/:id', is_auth_1.default, carteiraController.getCarteira);
// Fim Carteira
// HistoricoActividade
router.get('/historico-actividades', is_auth_1.default, historicoActividadeController.getHistoricoActividades);
router.get('/historico-actividade/:id', is_auth_1.default, historicoActividadeController.getHistoricoActividade);
// Fim HistoricoActividade
// WebAccess Historico de Acesso
router.post('/web-access/register', is_auth_1.default, schemas.webAccessRegister, webAccessController.registerWebAccess);
router.get('/web-accesses', is_auth_1.default, webAccessController.getWebAccesses);
router.get('/web-access/:id', is_auth_1.default, webAccessController.getWebAccess);
// Fim WebAccess Hitorico de Acesso
// Email
router.post('/email/send', is_auth_1.default, file_1.upload.single('attachment'), schemas.emailSend, send_email_1.sendEmail);
router.post('/email/postmark/send', is_auth_1.default, file_1.upload.single('attachment'), schemas.emailPosmarkSend, send_email_1.sendEmailPostmark);
// Fim Email
// Menus
router.get('/menu/principal', is_auth_1.default, menusController.getMenuPrincipal);
router.get('/menu/processos-inscricao', is_auth_1.default, menusController.getMenuProcessosInscricao);
router.get('/menu/eventos', is_auth_1.default, menusController.getMenuEventos);
//Fim Menus
// AWS
router.get('/get-url/:filename', is_auth_1.default, get_url_1.default);
// Fim AWS
// UtilizacaoMedicamento
router.get('/utilizacao-medicamento', 
//isAuthMiddleware,
utilizacaoMedicamentoController.getAllUtilizacaoMedicamentos);
router.get('/utilizacao-medicamento/:id', 
//isAuthMiddleware,
utilizacaoMedicamentoController.getOneUtilizacaoMedicamento);
router.post('/utilizacao-medicamento/create', 
//isAuthMiddleware,
schemas.createUtilizacaoMedicamento, utilizacaoMedicamentoController.createUtilizacaoMedicamento);
router.delete('/utilizacao-medicamento/:id', 
//isAuthMiddleware,
utilizacaoMedicamentoController.deleteUtilizacaoMedicamento);
// FIM UtilizacaoMedicamento
// Reclamacao
router.post('/reclamacao/create', (req, res, next) => {
    file_1.upload.fields([
        { name: 'anexo1', maxCount: 1 },
        { name: 'anexo2', maxCount: 1 },
    ])(req, res, function (err) {
        if (err) {
            next(err);
        }
        next();
    });
}, schemas.createReclamacao, reclamacaoController.createReclamacao);
router.get('/reclamacoes', is_auth_1.default, reclamacaoController.getReclamacoes);
router.get('/reclamacao/:id', is_auth_1.default, reclamacaoController.getReclamacao);
router.patch('/reclamacao/change-status', is_auth_1.default, schemas.changeReclamacaoStatus, reclamacaoController.changeStatus);
router.post('/reclamacao/response', is_auth_1.default, 
// schemas.sendResponse,
reclamacaoController.sendResponse);
// Fim reclamacao
// PDF
router.get('/pdf/comprovativo-pagamento/:idPagamento', is_auth_1.default, gerarPdfController.conprovativoPagamento);
//Fim PDF
exports.default = router;
